function [tau,adev] = gyro_allan_dev(rate,dt,pts)

N = length(rate);
M = 1;
%pts = 500; % Arbitrary size of log spaced vector
%N = length(int_norm_rate); % already assigned
n = 2.^(0:floor(log2(N/2)))'; % determine largest bin size
maxN = n(end);
endLogInc = log10(maxN);
% create log spaced vector average factor
m = unique(ceil(logspace(0,endLogInc,pts)))'; 
tau = m*dt; % T = length of time for each cluster
% integration of samples over time to obtain output angle
theta = cumsum(rate)*dt; 
% array of dimensions (cluster periods) X (#variables)
AV = zeros(length(tau),M); 
for i=1:length(m) % loop over the various cluster sizes
    for k=1:N-2*m(i) % implements the summation in the AV equation
    AV(i,:) = AV(i,:) + (theta(k+2*m(i),:) - 2*theta(k+m(i),:) + theta(k,:)).^2;
    end
end
AV = AV./repmat((2*tau.^2.*(N-2*m)),1,M); % Allan Variance
adev = sqrt(AV); % Allan Deviation

end